#include "winlink.h"

#include <direct.h>

extern void AdMame2x(u8 *srcPtr, u32 srcPitch, u8 * /* deltaPtr */,
					 u8 *dstPtr, u32 dstPitch, int width, int height);


extern void  SuperScale(unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned short width,unsigned short height);
extern void SuperScale75(unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned short width,unsigned short height);

extern void checkGeneralOptionsGGText();
extern int screenGeneralOptionsGGText;
extern void checkGeneralOptionsGG();
extern int screenGeneralOptionsGG;
extern std::string GARBAGE_PATH;
int hit = 0;

void setTriggerButton() {
	mousebuttons = 1; 
	keys[pl1Yk] = 1;   
}

void setTriggerNone() {
		mousebuttons &= 0x02;
		keys[pl1Yk] = 0; 
}

void setTriggerBOn() {
	mousebuttons |= 0x02;
	keys[pl1Bk] = 1;  
}

void setTriggerBOff() {
		mousebuttons &=0x01; 
		keys[pl1Bk] = 0;  
}
void checkTrigger() {
	
}
void sendRumble(unsigned char m1, unsigned char m2) {
	leftRumble = m1;
	rightRumble = m2;
}

void nSimple2x(u8 *srcPtr, u32 srcPitch, u8 * /* deltaPtr */,
			   u8 *dstPtr, u32 dstPitch, int width, int height)
{
	u8 *nextLine, *finish;

	nextLine = dstPtr + dstPitch;

	do {
		u32 *bP = (u32 *) srcPtr;
		u32 *dP = (u32 *) dstPtr;
		u32 *nL = (u32 *) nextLine;
		u32 currentPixel;

		finish = (u8 *) bP + ((width+2) << 1);
		currentPixel = *bP++;

		do {
			//#ifdef WORDS_BIGENDIAN
			//      u32 color = currentPixel >> 16;
			//#else
			u32 color = currentPixel & 0xffff;
			//#endif

			color = color | (color << 16);

			*(dP) = color;
			*(nL) = color;

			//#ifdef WORDS_BIGENDIAN
			//   color = currentPixel & 0xffff;
			//#else
			color = currentPixel >> 16;
			//#endif
			color = color| (color << 16);      
			*(dP + 1) = color;
			*(nL + 1) = color;

			currentPixel = *bP++;

			dP += 2;
			nL += 2;
		} while ((u8 *) bP < finish);

		srcPtr += srcPitch;
		dstPtr += dstPitch << 1;
		nextLine += dstPitch << 1;
	}
	while (--height);
}

BOOL InitSound()
{
	if(lpPrimaryBuffer)
		lpPrimaryBuffer->Release();
	StereoSound = 1;
	RevStereo = ReverseStereo;
	SoundEnabled = 0;
	if (cfgsoundon == 0) { return FALSE; }
	PrevSoundQuality=SoundQuality;
	PrevStereoSound=StereoSound;
	UsePrimaryBuffer=1;
	PrimaryBuffer=1;	
	UsePrimaryBuffer=1;
	wfx.wFormatTag = WAVE_FORMAT_PCM;
	switch (SoundQuality)
	{
	case 0:
		wfx.nSamplesPerSec = 8000;
		SoundBufferSize=1024*2;
		break;
	case 1:
		wfx.nSamplesPerSec = 11025;
		SoundBufferSize=1024*2;
		break;
	case 2:
		wfx.nSamplesPerSec = 22050;
		SoundBufferSize=1024*4;
		break;
	case 3:
		wfx.nSamplesPerSec = 44100;
		SoundBufferSize=1024*8;
		break;
	case 4:
		wfx.nSamplesPerSec = 16000;
		SoundBufferSize=1024*4;
		break;
	case 5:
		wfx.nSamplesPerSec = 32000;
		SoundBufferSize=1024*8;
		break;
	case 6:
		wfx.nSamplesPerSec = 48000;
		SoundBufferSize=1024*8;
		break;
	default:
		wfx.nSamplesPerSec = 11025;
		SoundBufferSize=1024*2;
	}
	if (StereoSound==1)
	{
		wfx.nChannels = 2;
		wfx.nBlockAlign = 4;
		SoundBufferSize*=2;
	}
	else
	{
		wfx.nChannels = 1;
		wfx.nBlockAlign = 2;
	}
	
	wfx.wBitsPerSample = 16;
	wfx.nAvgBytesPerSec = wfx.nSamplesPerSec * wfx.nBlockAlign;
	wfx.cbSize=0;
	memset(&dsbd, 0, sizeof(DSBUFFERDESC));
	dsbd.dwSize = sizeof(DSBUFFERDESC);
	dsbd.dwBufferBytes = SoundBufferSize;
	dsbd.lpwfxFormat = &wfx;

	if(m_pDSound == NULL) {  return FALSE; }

	if (DS_OK == m_pDSound->CreateSoundBuffer(&dsbd, &lpPrimaryBuffer, NULL))
	{
		if(musicType == 0) {
			DSMIXBINVOLUMEPAIR dsmbvp[8] = {
			{DSMIXBIN_FRONT_LEFT, DSBVOLUME_MAX},   // left channel
			{DSMIXBIN_FRONT_RIGHT, DSBVOLUME_MAX},  // right channel
			{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // left channel
			{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // right channel
			{DSMIXBIN_BACK_LEFT, DSBVOLUME_MAX},    // left channel
			{DSMIXBIN_BACK_RIGHT, DSBVOLUME_MAX},   // right channel
			{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX},    // left channel
			{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX}};   // right channel
			DSMIXBINS dsmb;
			dsmb.dwMixBinCount = 8;
			dsmb.lpMixBinVolumePairs = dsmbvp;
			lpPrimaryBuffer->SetMixBins(&dsmb);
		}
		if(musicType == 1) {
			DSMIXBINVOLUMEPAIR dsmbvp[4] = {
			{DSMIXBIN_FRONT_LEFT, DSBVOLUME_MAX},
			{DSMIXBIN_FRONT_RIGHT, DSBVOLUME_MAX},
			{DSMIXBIN_BACK_LEFT, -600},
			{DSMIXBIN_BACK_RIGHT, -600}};
			DSMIXBINS dsmb;
			dsmb.dwMixBinCount = 4;
			dsmb.lpMixBinVolumePairs = dsmbvp;
			lpPrimaryBuffer->SetMixBins(&dsmb);
		}
		if(musicType == 2) {
			DSMIXBINVOLUMEPAIR dsmbvp[4] = {
			DSMIXBINVOLUMEPAIRS_DEFAULT_STEREO, 
			{DSMIXBIN_I3DL2, DSBVOLUME_MAX},
			{DSMIXBIN_I3DL2, DSBVOLUME_MAX}}; // sent twice to get L+R
			DSMIXBINS dsmb;
			dsmb.dwMixBinCount = 4;
			dsmb.lpMixBinVolumePairs = dsmbvp;
			lpPrimaryBuffer->SetMixBins(&dsmb);
		}

		if(!UsePrimaryBuffer)
		{
			if (true){} else return FALSE;
		}
		else
		{
			void *mema=NULL,*memb=NULL;
			DWORD sizea=0,sizeb=0;
			lpPrimaryBuffer->Lock(0,SoundBufferSize, &mema, &sizea, &memb,&sizeb, 0);
			memset(mema,0,SoundBufferSize);
			lpPrimaryBuffer->Unlock(mema,sizea, memb,sizeb);
			if (DS_OK != lpPrimaryBuffer->Play(0,0,DSBPLAY_LOOPING)){return FALSE;}
		}
		SoundEnabled=1;
		FirstSound=0;
		return TRUE;
	}
	else
	{
		return FALSE;
	}
	return true;
}


//extern "C" begin
extern "C" {
	void FrameSemaphore(){
		if (T60HZEnabled)
		{
			double delay;
			QueryPerformanceCounter((LARGE_INTEGER*)&end);
			delay = ((update_ticks_pc - (end - start)) * 1000.0 / freq) - 3.0;
			if (delay>0.0) WaitForSingleObject(hLock, (unsigned int)delay);
		}
	}

	DWORD WINAPI SemaphoreThread( LPVOID lpParam )
	{
		while(semaphore_run)
		{
			if (T60HZEnabled)
			{
				ReleaseSemaphore(hLock, 1, NULL);
				Sleep(1);
			}
			else
				Sleep(20);
		}
		return 0;
	}

	void InitSemaphore()
	{
		if (hLock) return;
		hLock = CreateSemaphore(NULL, 1, SemaphoreMax, NULL);
		semaphore_run = 1;
		hThread = CreateThread(NULL, 0, SemaphoreThread, &dwThreadParam, 0, &dwThreadId);
	}

	void ShutdownSemaphore()
	{
		if (!hLock) return;
		semaphore_run = 0;
		WaitForSingleObject(hThread, INFINITE);
		CloseHandle(hThread);
		CloseHandle(hLock);
		hLock = NULL;
	}


	void Start60HZ(void)
	{
		update_ticks_pc2 = UPDATE_TICKS_UDP * freq / 1000.0;
		if (romispal==1)
		{
			update_ticks_pc = UPDATE_TICKS_GAMEPAL * freq / 1000.0;
		}
		else
		{
			update_ticks_pc = UPDATE_TICKS_GAME * freq / 1000.0;
		}
		QueryPerformanceCounter((LARGE_INTEGER*)&start);
		QueryPerformanceCounter((LARGE_INTEGER*)&start2);
		T36HZEnabled=0;
		T60HZEnabled=1;
		InitSemaphore();
	}

	void Stop60HZ(void)
	{
		T60HZEnabled=0;
		ShutdownSemaphore();
	}

	void Start36HZ(void)
	{
		update_ticks_pc2 = UPDATE_TICKS_UDP * freq / 1000.0;
		update_ticks_pc = UPDATE_TICKS_GUI * freq / 1000.0;
		QueryPerformanceCounter((LARGE_INTEGER*)&start);
		QueryPerformanceCounter((LARGE_INTEGER*)&start2);
		T60HZEnabled=0;
		T36HZEnabled=1;
	}

	void CheckTimers(void)
	{
		// Lame fix for GUI using 100% CPU
		if (GUIOn || GUIOn2) Sleep(1);
		QueryPerformanceCounter((LARGE_INTEGER*)&end2);
		while ((end2 - start2) >= update_ticks_pc2){start2 += update_ticks_pc2;}
		if (T60HZEnabled == 1)
		{
			QueryPerformanceCounter((LARGE_INTEGER*)&end);

			while ((end - start) >= update_ticks_pc)
			{
				Game60hzcall();
				start += update_ticks_pc;
			}
		}

		if (T36HZEnabled == 1)
		{
			QueryPerformanceCounter((LARGE_INTEGER*)&end);

			while ((end - start) >= update_ticks_pc)
			{
				GUI36hzcall();
				start += update_ticks_pc;
			}
		}
	}


	void setSurroundSound() {
		if(SurroundSound == 1) {
			Surround = 1; 

			InitSound();
			AdjustFrequency();

		}
		else {
			Surround = 0;

			InitSound();
			AdjustFrequency();

		}
	}

	void setSoundInterpolation() {
		if(SoundInterpolation == 0) {
			SoundInterpType = 1;

			InitSound();
			AdjustFrequency();

		}
		if(SoundInterpolation == 1) {
			SoundInterpType = 2;

			InitSound();
			AdjustFrequency();

		}
		if(SoundInterpolation == 2) {
			SoundInterpType = 3;

			InitSound();
			AdjustFrequency();

		}
	}


	void setLowPassFilter() {
		if(LowPassFilter == 0) {
			LowPassFilterType = 0;

			InitSound();
			AdjustFrequency();

		}
		if(LowPassFilter == 1) {
			LowPassFilterType = 1;

			InitSound();
			AdjustFrequency();

		}
		if(LowPassFilter == 2) {
			LowPassFilterType = 2;

			InitSound();
			AdjustFrequency();

		}
		if(LowPassFilter == 3) {
			LowPassFilterType = 3;

			InitSound();
			AdjustFrequency();

		}
	}

	void setSoundType() {
			InitSound();
			AdjustFrequency();
	}

	void setFrequency() {
		if(SoundFrequency == 0) {
			SoundQuality = 5;
			cfgSoundQuality = 5;

			InitSound();
			AdjustFrequency();

		}
		else if(SoundFrequency == 1) {
			SoundQuality = 3;
			cfgSoundQuality = 3;

			InitSound();
			AdjustFrequency();

		}
		else if(SoundFrequency == 2) {
			SoundQuality = 6;
			cfgSoundQuality = 6;

			InitSound();
			AdjustFrequency();

		}
	}



	int p1 = 0;
	int p2 = 1;
	int p3 = 2;
	int p4 = 3;
	extern unsigned char snesmouse;


	void setRender();


	extern unsigned short gameCRC;
	void getCRC();


	
	void initwinvideo(void)
	{

		
		setRender();


		mY = sHeight/2;
		mX = sWidth/2;
		oldmX = 0;
		oldmY = 0;

		if(controllerType == 0) snesmouse = controllerType;
		if(controllerType == 1) snesmouse = controllerType;
		if(controllerType == 2) snesmouse = 3;


		FPSAtStart = ShowFPS; 
		FPSOn = ShowFPS;

		unsigned int color32,ScreenPtr2;
		int i, j, k, r, g, b, Y, u, v;


		ScreenPtr2=BitConv32Ptr;
		for(i=0;i<65536;i++)
		{
			color32=((i&0xF800)<<8)+
				((i&0x07E0)<<5)+
				((i&0x001F)<<3)+0xFF000000;
			(*(unsigned int *)(ScreenPtr2))=color32;
			ScreenPtr2+=4;
		}

		for (i=0; i<32; i++)
			for (j=0; j<64; j++)
				for (k=0; k<32; k++)
				{
					r = i << 3;
					g = j << 2;
					b = k << 3;
					Y = (r + g + b) >> 2;
					u = 128 + ((r - b) >> 2);
					v = 128 + ((-r + 2*g -b)>>3);
					*(((unsigned int *)RGBtoYUVPtr) + (i << 11) + (j << 5) + k) = (Y<<16) + (u<<8) + v;
				}


				pl1Xtk = 210; 
				pl1Ytk = 211; 
				pl1Atk = 212; 
				pl1Btk = 213; 
				pl1Ltk = 209; 
				pl1Rtk = 214;

				pl2Xtk = 215; 
				pl2Ytk = 216; 
				pl2Atk = 217; 
				pl2Btk = 218; 
				pl2Ltk = 219; 
				pl2Rtk = 220;

				pl3Xtk = 221; 
				pl3Ytk = 222; 
				pl3Atk = 223; 
				pl3Btk = 224; 
				pl3Ltk = 225; 
				pl3Rtk = 226;

				pl4Xtk = 227; 
				pl4Ytk = 228; 
				pl4Atk = 229; 
				pl4Btk = 230; 
				pl4Ltk = 231; 
				pl4Rtk = 232;

				SPCSize=256;
				pl1selk = 40;
				pl1startk = 41;
				pl1upk = 200;
				pl1downk = 208;
				pl1leftk = 203;
				pl1rightk = 205;
				pl1Ak = 42;
				pl1Bk = 43;
				pl1Lk = 44;
				pl1Rk = 45;
				pl1Xk = 46;
				pl1Yk = 47;

				pl2upk = 26;
				pl2downk = 27;
				pl2leftk = 28;
				pl2rightk = 29;
				pl2startk = 30;
				pl2selk = 31;
				pl2Ak = 32;
				pl2Bk = 33;
				pl2Xk = 34;
				pl2Yk = 35;
				pl2Lk = 36;
				pl2Rk = 37;


				pl3upk = 100;
				pl3downk = 101;
				pl3leftk = 102;
				pl3rightk = 103;
				pl3startk = 104;
				pl3selk = 105;
				pl3Ak = 106;
				pl3Bk = 107;
				pl3Xk = 108;
				pl3Yk = 109;
				pl3Lk = 110;
				pl3Rk = 111;



				pl4upk = 112;
				pl4downk = 113;
				pl4leftk = 114;
				pl4rightk = 115;
				pl4startk = 116;
				pl4selk = 117;
				pl4Ak = 118;
				pl4Bk = 119;
				pl4Xk = 120;
				pl4Yk = 121;
				pl4Lk = 122;
				pl4Rk = 123;

				pl1contrl = 1;
				pl2contrl = 1;
				pl3contrl = Disable34;
				pl4contrl = Disable34;

				KeySaveState = 72;
				KeyLoadState = 73;
				KeyFastFrwrd = 74;
				KeyVolUp = 150;
				KeyVolDown = 151;
				KeyRewind = 153;
				KeyQuickRst = 154;
				KeyNewGfxSwt = 152;
				KeyUsePlayer1234 = 233;
				setFrequency();
				setSoundInterpolation(); 
				setLowPassFilter();
				setSurroundSound(); 
				RevStereo = ReverseStereo;
				Turbo30hz = fastTurbo;
				//KeyQuickRst = 41;


				//KeyRewind = 0;

				RECT rc1;
				DWORD newmode=0;
				DWORD HQMode=0;

				if ( hqFilter != 0 )
				{
					if ( GUIHQ2X[cvidmode] != 0 ) HQMode=2;
					if ( GUIHQ3X[cvidmode] != 0 ) HQMode=3;
					if ( GUIHQ4X[cvidmode] != 0 ) HQMode=4;
				}

				if ((CurMode!=cvidmode) || (prevHQMode!=HQMode))
				{
					CurMode=cvidmode;
					prevHQMode=HQMode;
					newmode=1;
					SurfaceX=256;
					SurfaceY=240;
					X=0;
					Y=0;
					FullScreen=GUIWFVID[cvidmode];
					DMode=GUIDSIZE[cvidmode];
					SMode=GUISMODE[cvidmode];
					DSMode=GUIDSMODE[cvidmode];

					switch (cvidmode)
					{
					case 0:
						WindowWidth=256;
						WindowHeight=224;
						break;
					case 1:
						WindowWidth=640;
						WindowHeight=480;
						break;
					case 2:
					case 3:
						WindowWidth=512;
						WindowHeight=448;
						break;
					case 4:
					case 5:
					case 6:
					case 7:
					case 8:
						WindowWidth=640;
						WindowHeight=480;
						break;
					case 9:
					case 10:
						WindowWidth=768;
						WindowHeight=672;
						break;
					case 11:
					case 12:
					case 13:
					case 14:
					case 15:
						WindowWidth=800;
						WindowHeight=600;
						break;
					case 16:
					case 17:
					case 18:
					case 19:
					case 20:
						WindowWidth=1024;
						WindowHeight=768;
						break;
					case 21:
					case 22:
						WindowWidth=1024;
						WindowHeight=896;
						break;
					case 23:
					case 24:
					case 25:
					case 26:
					case 27:
						WindowWidth=1280;
						WindowHeight=960;
						break;
					case 28:
					case 29:
					case 30:
					case 31:
					case 32:
						WindowWidth=1280;
						WindowHeight=1024;
						break;
					case 33:
					case 34:
					case 35:
					case 36:
						WindowWidth=1600;
						WindowHeight=1024;
						break;
					case 37:
						WindowWidth=1680;
						WindowHeight=1050;
						break;
					default:
						WindowWidth=256;
						WindowHeight=224;
						break;
					}

					if (DMode == 1)
					{
						if ((DSMode == 1) || (FullScreen == 0))
							SurfaceX = 512;
						else
							SurfaceX = 640;

						SurfaceY=480;
					}
					else
					{
						if ((SMode == 0) && (FullScreen == 1))
							SurfaceX=320;
						else
							SurfaceX=256;
						SurfaceY=240;
					}

					switch ( HQMode )
					{
					case 2:
						SurfaceX=512;
						SurfaceY=480;
						break;
					case 3:
						SurfaceX=768;
						SurfaceY=720;
						break;
					case 4:
						SurfaceX=1024;
						SurfaceY=960;
						break;
					}
					BlitArea.top = 0;
					BlitArea.left = 0;
					BlitArea.right = SurfaceX;
					if ((SurfaceX == 600) || (SurfaceX == 640) || (SurfaceX == 320))
						BlitArea.bottom = SurfaceY;
					else
						BlitArea.bottom = (SurfaceY/240)*resolutn;

					if (PrevRes == 0) PrevRes = resolutn;
				}

				if (((PrevStereoSound!=StereoSound)||(PrevSoundQuality!=SoundQuality))&&FirstSound!=1)
					ReInitSound();

				if (!FirstVid)
				{
					if (X<0)X=0;
					if (Y<0)Y=0;
					if (FullScreen==1) {X=0; Y=0;}
					if (FullScreen==0 && newmode == 1) { X = MainWindowX; Y = MainWindowY; }
					else if (FullScreen==0) { MainWindowX = X; MainWindowY = Y; }
					SetRect(&rc1, 0, 0, WindowWidth, WindowHeight);
					if (FullScreen == 1)
					{
						if (HQMode && !DSMode)
						{
							int marginx = (rcWindow.right - rcWindow.left - BlitArea.right + BlitArea.left)/2;
							int marginy = (rcWindow.bottom - rcWindow.top - BlitArea.bottom + BlitArea.top)/2;
							if (marginx>0)
							{
								rcWindow.left += marginx;
								rcWindow.right -= marginx;
							}
							if (marginy>0)
							{
								rcWindow.top += marginy;
								rcWindow.bottom -= marginy;
							}
						}

						if ((DSMode == 1) && (scanlines != 0))
						{
							int OldHeight = rcWindow.bottom - rcWindow.top;
							if ((OldHeight % 240) == 0)
							{
								int NewHeight = (OldHeight/240)*resolutn;
								rcWindow.top += (OldHeight - NewHeight)/2;
								rcWindow.bottom = rcWindow.top + NewHeight;
								clear_display();
							}
						}
					}
				}
				else
				{
					atexit(ExitFunction);
					if (!QueryPerformanceFrequency((LARGE_INTEGER*)&freq)) return;
					if (FullScreen==1) {X=0; Y=0;}
					if (SaveMainWindowPos == 1 && MainWindowX != -1 && FullScreen == 0) { X = MainWindowX; Y = MainWindowY; }
					CheckPriority();
					CheckAlwaysOnTop();
					CheckScreenSaver();
					InitInput();
					InitSound();
					TestJoy();
					if (debugger) InitDebugger(); // Start debugger such that it is at this point
				}

				if (FirstVid == 1)
				{
					FirstVid = 0;
					if (Force60hz) Refresh = 60;
					InitDirectDraw();
					clearwin();
					Clear2xSaIBuffer();
					clear_display();
					return;
				}

				if (Moving == 1) return;

				if (newmode == 1)
				{
					ReleaseDirectDraw();
					InitDirectDraw();
					clearwin();
					Clear2xSaIBuffer();
					clear_display();
					return;
				}
	}


	int getPitch() { return pitch; }

	void SetSPCEnable() {}

	void setHardwareFilter() {
		if(HardwareFilter == 0) {//NONE
			Device->SetTextureStageState(0, D3DTSS_MIPFILTER,D3DTEXF_NONE);
		}
		if(HardwareFilter == 1) {//POINT
			Device->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_POINT);
			Device->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_POINT);
			Device->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);
		}
		if(HardwareFilter == 2) {//Bilinear
			Device->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
			Device->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);
			Device->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_POINT);
		}
		if(HardwareFilter == 3) {//Trilinear
			Device->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
			Device->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);
			Device->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_LINEAR);
		}
		if(HardwareFilter == 4) {//Anisotrpoic
			float fBias = -4.0;
			Device->SetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, *((LPDWORD) (&fBias)));
			Device->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_ANISOTROPIC);
			Device->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_ANISOTROPIC);
			Device->SetTextureStageState(0, D3DTSS_MAXANISOTROPY, 4);
		}
		if(HardwareFilter == 5) {//Quincunx
			Device->SetTextureStageState(0, D3DTSS_MAGFILTER,D3DTEXF_QUINCUNX);
			Device->SetTextureStageState(0, D3DTSS_MINFILTER,D3DTEXF_QUINCUNX);
		}
		if(HardwareFilter == 6) {//Gaussian Cubic
			Device->SetTextureStageState(0, D3DTSS_MAGFILTER,D3DTEXF_GAUSSIANCUBIC);
			Device->SetTextureStageState(0, D3DTSS_MINFILTER,D3DTEXF_GAUSSIANCUBIC);
		}
	}

	extern unsigned char MusicRelVol;

	extern void SaveSramData();

	void blankScreen() {
		ClearWin16();
		asm_call(Clear2xSaIBuffer);
		TexScreen->LockRect( 0, &lockScreen, 0, 0L );
		SurfBuf = (BYTE*)lockScreen.pBits;
		pitch = lockScreen.Pitch;
		Mode7HiRes16b = 0;
		En2xSaI = 0;
		scanlines = 0;
		hqFilter = 0;
		antienab = 0;
		firstVidRender = 0;
		AddEndBytes=pitch-1024;
		NumBytesPerLine=pitch;
		WinVidMemStart= (unsigned char*) &(SurfBuf[(240-resolutn)*pitch+128]);
		asm_call(copy640x480x16bwin);
		TexScreen->UnlockRect(0);
		Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
		Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
		Device->Present(NULL,NULL,NULL,NULL);  
		return;
	}


	int ZsnesMenuUpdate()
	{

		if (g_Gamepads[0].fY2 > 0 && inGame != 1 && screenResize != 1 
			&& musicMode != 1 && screenResizeP != 1 && screenResizeI != 1 
			&& screenResizeGP != 1 && screenResizeMPL != 1 && screenResizeJ != 1 
			&& fontResizeClip != 1 && screenResizeG != 1 && screenResizeB != 1 
			&& screenResizeA != 1 && screenResizeA2 != 1 && screenResizeS != 1 
			&& screenResizePB != 1) {BGVol += 10.0f; setVolume(); }// Up
		if (g_Gamepads[0].fY2 < 0 && inGame != 1 && screenResize != 1 
			&& musicMode != 1 && screenResizeP != 1 && screenResizeI != 1 
			&& screenResizeGP != 1 && screenResizeMPL != 1 && screenResizeJ != 1 
			&& fontResizeClip != 1 && screenResizeG != 1 && screenResizeB != 1 
			&& screenResizeA != 1 && screenResizeA2 != 1 && screenResizeS != 1 
			&& screenResizePB != 1) {BGVol -= 10.0f; setVolume();}

		if(musicPlayer == 1) {
			if(musicMode == 0) {
				if(g_Gamepads[0].Event == XBGAMEPAD_X) {
					if(vgplaying == 1) stopMusic();
					resetThemeSong();
				}
			}
			else {
				if(g_Gamepads[0].Event == XBGAMEPAD_WHITE) {
					if(vgplaying == 1) nextTrack();  
				}
				if(g_Gamepads[0].Event == XBGAMEPAD_BLACK) {
					if(vgplaying == 1) previousTrack();
				}
				if(g_Gamepads[0].Event == XBGAMEPAD_X) {
					if(vgplaying == 1) {			  
						stopMusic();
						resumeMusic();
					}
				}
			}
		}
		if(keyBoardDraw == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B && checkStateK()) {
				if(DisableMenuSounds == 0) playEffect(1);
				
				Device->SetTexture( 3, NULL );
				Device->SetTextureStageState( 3, D3DTSS_COLOROP, D3DTOP_DISABLE );
				Device->SetRenderState( D3DRS_POINTSPRITEENABLE, FALSE );
				Device->SetRenderState( D3DRS_POINTSCALEENABLE,  FALSE );
				Device->SetRenderState( D3DRS_ALPHABLENDENABLE,  FALSE );
				keyBoardDraw = 0;
				clearKeyboard();
				return 0;
			}
			drawKeyboard();
			return 0;
		}

		if(g_Gamepads[0].Event == XBGAMEPAD_Y && lightGun == 1 && correctAppState() == 1) {
			Device->SetTexture( 3, NULL );
			Device->SetTextureStageState( 3, D3DTSS_COLOROP, D3DTOP_DISABLE );
			Device->SetRenderState( D3DRS_POINTSPRITEENABLE, FALSE );
			Device->SetRenderState( D3DRS_POINTSCALEENABLE,  FALSE );
			Device->SetRenderState( D3DRS_ALPHABLENDENABLE,  FALSE );
			lightGun = 0;
			return 0;
		}	

		if(lightGun == 1) {
			ProcessLightGun();
			return 0;
		}

		if(screenSoundOptions == 1) {
			checkSoundOptions();
			return 0;
		}

		if(archiveMode == 1) {
			processArchiveList();
			return 0;
		}

		if(screenMPOptions == 1) {
			checkMPOptions();
			return 0;
		}

		if(screenGeneralOptions == 1) {
			checkGeneralOptions();
			return 0;
		}
		if(screenGeneralOptionsGG == 1) {
			checkGeneralOptionsGG();
			return 0;
		}

		if(screenGeneralOptionsGGText == 1) {
			checkGeneralOptionsGGText();
			return 0;
		}
		if(screenGUIOptions == 1) {
			checkGUIOptions();
			return 0;
		}

		if(screenVideoOptions == 1) {
			checkVideoOptions();
			return 0;
		}

		if(screenOptions == 1) {
			//Change menu options here
			if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP)  {  
				if(DisableMenuSounds == 0)playEffect(0);	
				optionSelected -= 1; 
				if(inGame == 1) {
					if(optionSelected < 0) optionSelected = 11; 
				}
				else {
					if(optionSelected < 6) optionSelected = 11;
				}
			}

			if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN) {  
				if(DisableMenuSounds == 0)playEffect(0);	
				optionSelected += 1; 
				if(inGame == 1) {
					if(optionSelected > 11) optionSelected = 0;
				}
				else {
					if(optionSelected > 11) optionSelected = 6;
				}

			} 
			int r = checkA();
			return r;
		}
		if(screenCheatOptions == 1) {
			processCheatOptions();
			return 0;
		}

		if(saveStateSave == 1) {
			return processStateOptions();
		}

		if(saveStateLoad == 1) {
			return processStateOptions();
		}

		if(screenControllerOptions == 1) {
			checkControllerConfig();

			return 0;
		}

		if(screenGeneralOptionsMP == 1) {
			checkMPOptions();
			return 0;
		}

		if(screenResize == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResize = 0;
				screenResizeP = 0;
				screenResizeI = 0;
				screenResizePB = 0;
				screenResizeJ = 0;
				screenResizeG = 0;
				screenResizeB = 0;
				screenResizeA = 0;
				screenOptionsM = 0;
				screenResizeS = 0;
				screenVideoOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTop+=0.01f;  zBottom+=0.01f; }// Up
			if (g_Gamepads[0].fY1 < 0) {zTop-=0.01f;  zBottom-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeft-=0.01f; zRight-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeft+=0.01f; zRight+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottom+=0.01f; // Up
			if (g_Gamepads[0].fY2 < 0) zBottom-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRight-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRight+=0.01f; // Right
			return 0; 

		}

		if(errorFound == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_A) {
				LD_LAUNCH_DASHBOARD launch;
				memset(&launch,0,sizeof(launch));
				launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
				XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch); 
			}
			return 0; 
		}

		if(fontResizeR == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeR = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopBR-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopBR+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftBR-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftBR+=1;  }// Right
			return 0; 

		}

		if(fontResizeEO == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeEO = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopEO-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopEO+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftEO-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftEO+=1;  }// Right
			return 0; 

		}

		if(fontResizeCO == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeCO = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopCO-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopCO+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftCO-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftCO+=1;  }// Right
			return 0; 

		}

		if(fontResizeCC == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeCC = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopCC-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopCC+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftCC-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftCC+=1;  }// Right
			return 0; 

		}

		if(fontResizeClip == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeClip = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {rC-=1;  rCHeight-=1; }// Up
			if (g_Gamepads[0].fY1 < 0) {rC+=1;  rCHeight+=1; } // Down
			if (g_Gamepads[0].fX1 < 0) {lC-=1; lCWidth-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {lC+=1; lCWidth+=1; }// Right

			if (g_Gamepads[0].fY2 > 0) rCHeight-=1; // Up
			if (g_Gamepads[0].fY2 < 0) rCHeight+=1; // Down
			if (g_Gamepads[0].fX2 < 0) lCWidth-=1; // Left
			if (g_Gamepads[0].fX2 > 0) lCWidth+=1; // Right
			return 0; 

		}

		if(fontResizeTO == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeTO = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopTO-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopTO+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftTO-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftTO+=1;  }// Right
			return 0; 

		}

		if(fontResizeCCO == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeCCO = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopCCO-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopCCO+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftCCO-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftCCO+=1;  }// Right
			return 0; 

		}

		if(fontResizeV == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeV = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopV-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopV+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftV-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftV+=1;  }// Right
			return 0; 

		}

		if(fontResizeRumble == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeRumble = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopRM-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopRM+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftRM-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftRM+=1;  }// Right
			return 0; 

		}
		if(fontResizeGT == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeGT = 0; screenGUIOptions = 1;
				LoopMode = 2;
				gFont = 2;
				writeConfig();
				return 0;
			}
			if (g_Gamepads[0].fY1 > 0) {zTopGT-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopGT+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftGT-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftGT+=1;  }// Right
			return 0; 

		}

		if(fontResizeIT == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeIT = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopIT-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopIT+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftIT-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftIT+=1;  }// Right
			return 0; 

		}

		if(fontResizeS == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeS = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopSM-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopSM+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftSM-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftSM+=1;  }// Right
			return 0; 

		}

		if(fontResizeG == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeG = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopGM-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopGM+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftGM-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftGM+=1;  }// Right
			return 0; 

		}

		if(fontResizeCD == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeCD = 0; screenGUIOptions = 1;
				gFont = 2;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopCD-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopCD+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftCD-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftCD+=1;  }// Right
			return 0; 

		}

		if(fontResizeM == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeM = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopMM-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopMM+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftMM-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftMM+=1;  }// Right
			return 0; 

		}

		if(fontResizeF == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeF = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopBF-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopBF+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftBF-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftBF+=1;  }// Right
			return 0; 

		}

		if(screenResizeP == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeP = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopP+=0.01f;  zBottomP+=0.01f; }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopP-=0.01f;  zBottomP-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftP-=0.01f; zRightP-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftP+=0.01f; zRightP+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomP+=0.01f; // Up
			if (g_Gamepads[0].fY2 < 0) zBottomP-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightP-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightP+=0.01f; // Right
			return 0; 

		}

		if(screenResizeI == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeI = 0;
				LoopMode = 2;
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopP+=0.01f;  zBottomP+=0.01f; }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopP-=0.01f;  zBottomP-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftP-=0.01f; zRightP-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftP+=0.01f; zRightP+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomP+=0.01f; // Up
			if (g_Gamepads[0].fY2 < 0) zBottomP-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightP-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightP+=0.01f; // Right
			return 0; 

		}

		if(screenResizeGP == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeGP = 0; screenMPOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopGP+=0.01f;  zBottomGP+=0.01f; }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopGP-=0.01f;  zBottomGP-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftGP-=0.01f; zRightGP-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftGP+=0.01f; zRightGP+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomGP+=0.01f; // Up
			if (g_Gamepads[0].fY2 < 0) zBottomGP-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightGP-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightGP+=0.01f; // Right


			return 0; 

		}

		if(screenResizePB == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizePB = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopPB+=0.01f;  zBottomPB+=0.01f; }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopPB-=0.01f;  zBottomPB-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftPB-=0.01f; zRightPB-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftPB+=0.01f; zRightPB+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomPB+=0.01f; // Up
			if (g_Gamepads[0].fY2 < 0) zBottomPB-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightPB-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightPB+=0.01f; // Right
			return 0; 

		}

		if(screenResizeMPL == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeMPL = 0; screenMPOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();

				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopMPL-=1;  zBottomMPL+=1; }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopMPL+=1;  zBottomMPL-=1; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftMPL-=1; zRightMPL-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftMPL+=1; zRightMPL+=1; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomMPL-=1; // Up
			if (g_Gamepads[0].fY2 < 0) zBottomMPL+=1; // Down
			if (g_Gamepads[0].fX2 < 0) zRightMPL-=1; // Left
			if (g_Gamepads[0].fX2 > 0) zRightMPL+=1; // Right


			return 0; 

		}
		if(screenOptionsHelp == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenOptionsHelp = 0;
				LoopMode = 2;
				writeConfig();
				screenOptionsM = 1;
				fadeColor = 255;
				fadeColor2 = 255;
				//restoreResolution();
				clearHelp();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {if(zTopHT < (rC - 130))zTopHT+=5;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopHT-=5;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftHT-=1;  } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftHT+=1;  }// Right
			return 0; 


			return 0; 

		}
		if(screenResizeJ == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeJ = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopJ+=0.01f;  zBottomJ+=0.01f; }// UJ
			if (g_Gamepads[0].fY1 < 0) {zTopJ-=0.01f;  zBottomJ-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftJ-=0.01f; zRightJ-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftJ+=0.01f; zRightJ+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomJ+=0.01f; // UJ
			if (g_Gamepads[0].fY2 < 0) zBottomJ-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightJ-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightJ+=0.01f; // Right
			return 0; 

		}

		if(screenResizeG == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeG = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopG+=0.01f;  zBottomG+=0.01f; }// UJ
			if (g_Gamepads[0].fY1 < 0) {zTopG-=0.01f;  zBottomG-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftG-=0.01f; zRightG-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftG+=0.01f; zRightG+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomG+=0.01f; // UJ
			if (g_Gamepads[0].fY2 < 0) zBottomG-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightG-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightG+=0.01f; // Right
			return 0; 

		}

		if(screenResizeB == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeB = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopB+=0.01f;  zBottomB+=0.01f; }// UJ
			if (g_Gamepads[0].fY1 < 0) {zTopB-=0.01f;  zBottomB-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftB-=0.01f; zRightB-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftB+=0.01f; zRightB+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomB+=0.01f; // UJ
			if (g_Gamepads[0].fY2 < 0) zBottomB-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightB-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightB+=0.01f; // Right
			return 0; 

		}

		if(screenResizeA == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeA = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopA+=0.01f;  zBottomA+=0.01f; }// UJ
			if (g_Gamepads[0].fY1 < 0) {zTopA-=0.01f;  zBottomA-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftA-=0.01f; zRightA-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftA+=0.01f; zRightA+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomA+=0.01f; // UJ
			if (g_Gamepads[0].fY2 < 0) zBottomA-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightA-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightA+=0.01f; // Right

			zLeftA2 = zLeftA;
			zRightA2 = zRightA;
			zTopA2 = zTopA;
			zBottomA2 = zBottomA;
			return 0; 

		}


		if(screenResizeA2 == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeA2 = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopAR+=0.01f;  zBottomAR+=0.01f; }// UJ
			if (g_Gamepads[0].fY1 < 0) {zTopAR-=0.01f;  zBottomAR-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftAR-=0.01f; zRightAR-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftAR+=0.01f; zRightAR+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomAR+=0.01f; // UJ
			if (g_Gamepads[0].fY2 < 0) zBottomAR-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightAR-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightAR+=0.01f; // Right

			zLeftA2R = zLeftAR;
			zRightA2R = zRightAR;
			zTopA2R = zTopAR;
			zBottomA2R = zBottomAR;
			return 0; 

		}

		if(screenOptionsM == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_A) {
				if(DisableMenuSounds == 0) playEffect(2);
				if(optionSelectedM == 0 ) {
					if(backupChanged == 0) {
						FileMenuSelected = 0;
						std::string path =romBasePath;
						searchDirectory(path, false);
					}
					else {
						restoreRomBrowser();
					}
					favorites = 0;
					
					fadeOption = 0; fadeColor = 255; fadeColor2 = 255;screenOptionsM = 0; currentStationaryFrame = 0;  screenOptions = 0; screenGUIOptions = 0;
					screenShotSlotAuto = 1;
					wasThere = 0;
					changePreview();
					lastTimeScreenShotSwitch = (FLOAT)tickScreenShotSwitch.QuadPart;
				
				}
				if(optionSelectedM == 1 ) {
					buildFavorites();
					favorites = 1;
					fadeOption = 0; fadeColor = 255; 
					fadeColor2 = 255;
					screenOptionsM = 0; 
					screenOptions = 0; 
					currentStationaryFrame = 0; 
					screenGUIOptions = 0;
					screenShotSlotAuto = 1;
					wasThere = 0;
					changePreview();
					lastTimeScreenShotSwitch = (FLOAT)tickScreenShotSwitch.QuadPart;
				}
				if(optionSelectedM == 3 ) { fadeOption = 1; fadeColor = 255; fadeColor2 = 255;screenOptionsM = 0; screenOptions = 1; screenGUIOptions = 0;}
				if(optionSelectedM == 4) { fadeOption = 2; fadeColor = 255; fadeColor2 = 255;screenOptionsM = 0;screenOptionsHelp = 1; loadHelp(); screenOptions = 0; screenGUIOptions = 0;}
				if(optionSelectedM == 2 ) { 
					if(optionSelectedM == 2 ) { 
						fadeOption = 2; fadeColor = 255; fadeColor2 = 255;screenOptionsM = 0; 
						screenOptions = 0; screenGUIOptions = 0;
						screenGeneralOptionsMP = 1;
					}
				}
				
				if(optionSelectedM == 5 ) {
					screenResizeE = 1; screenOptionsM = 0;
					fadeOption = 1;
					fadeColor = 255;
					fadeColor2 = 255;
				}
				zA = 0;
				LoopMode = 2;
				return 0;
			}

			if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP)  {  
				if(DisableMenuSounds == 0)playEffect(0);	
				optionSelectedM -= 1; 
				if(optionSelectedM < 0) optionSelectedM = 5;
			}

			if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN) {  
				if(DisableMenuSounds == 0)playEffect(0);	
				optionSelectedM += 1; 
				if(optionSelectedM > 5) optionSelectedM = 0;

			} 
			return 0;
		}

		if(screenResizeE == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeE = 0; screenOptionsM = 1;
				LoopMode = 2;
				fadeColor = 255;
				fadeColor2 = 255;
				return 0;
			}

			if(g_Gamepads[0].Event == XBGAMEPAD_Y) {
				writeConfig();
				LD_LAUNCH_DASHBOARD launch;
				memset(&launch,0,sizeof(launch));
				launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
				XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch); 
				return 0;
			}
			return 0;
		}

		if(screenResizeS == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeS = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopS+=0.01f;  zBottomS+=0.01f; }// UJ
			if (g_Gamepads[0].fY1 < 0) {zTopS-=0.01f;  zBottomS-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftS-=0.01f; zRightS-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftS+=0.01f; zRightS+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomS+=0.01f; // UJ
			if (g_Gamepads[0].fY2 < 0) zBottomS-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightS-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightS+=0.01f; // Right
			return 0; 

		}
		if(confirmDelete == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				confirmDelete = 0;
				return 0;
			}
			if ((g_Gamepads[0].Event == XBGAMEPAD_A) ) {
				std::string a = GARBAGE_PATH;//
				std::string newName = a + fileList[FileMenuSelected].name.c_str();
				int r = MoveFileEx(fileList[FileMenuSelected].path.c_str(),  newName.c_str(), MOVEFILE_COPY_ALLOWED);
				if(r != 0) {
					fileList.erase(fileList.begin()+FileMenuSelected); 
					if(FileMenuSelected != 0) FileMenuSelected--;
					screenShotSlotAuto = 1;
					wasThere = 0;
					changePreview();
					lastTimeScreenShotSwitch = (FLOAT)tickScreenShotSwitch.QuadPart;
				}
				confirmDelete = 0;
				return 0;
			}
			return 0; 

		}

		if(favoriteAdd == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				favoriteAdd = 0;
				return 0;
			}
			return 0; 
		}
		if(LoopMode != 8) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1); 
				if(musicPlayer == 1) {
					musicPlayer = 0;
					screenGeneralOptionsMP = 1;
					releaseMP();
					return 0;
				}

				if(favorites == 1) {
					favorites = 0;
					saveFavoritesExit();
				}
				else {
					saveFavorites();
				}

				screenOptionsM = 1;
				fadeColor = 255;
				fadeColor2 = 255;
				return 0;
			} 
			if(g_Gamepads[0].fX2 == 0) analogStill = 1;

			if(g_Gamepads[0].Event == XBGAMEPAD_BLACK && favorites == 0 && musicPlayer != 1) {
				if(fileList[FileMenuSelected].isAGame) {  
					confirmDelete = 1;
				}
				return 0;
			}

			if(g_Gamepads[0].Event == XBGAMEPAD_WHITE && musicPlayer != 1) {
				if(fileList[FileMenuSelected].isAGame) {  
					if(favorites == 0) {
						addToFavorites();
						favoriteAdd = 1;
					}
					else {
						removeFromFavorites();
						screenShotSlotAuto = 1;
						wasThere = 0;
						changePreview();
						lastTimeScreenShotSwitch = (FLOAT)tickScreenShotSwitch.QuadPart;
					}
					//
				}
				return 0;
			}

			if(menuChanged == true 
				&& !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) {
					screenShotSlotAuto = 1;
					wasThere = 0;
					changePreview();
					lastTimeScreenShotSwitch = (FLOAT)tickScreenShotSwitch.QuadPart;
					updateZipFilename();
					menuChanged = false;
					return 0;
				}
				if(g_Gamepads[0].fX2 < 0 && automaticScreenShotSwitching == 0 && analogStill == 1 && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) {  //left
					analogStill = 0;
					oldScreenShot = screenShotSlotAuto;
					screenShotSlotAuto -= 1;
					if(screenShotSlotAuto < 1) screenShotSlotAuto = 8;
					changePreviewDown();
					lastTimeScreenShotSwitch = (FLOAT)tickScreenShotSwitch.QuadPart;
					return 0;
				}
				if(g_Gamepads[0].fX2 > 0  && automaticScreenShotSwitching == 0 && analogStill == 1 && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) { //right
					analogStill = 0;
					oldScreenShot = screenShotSlotAuto;
					screenShotSlotAuto += 1;
					if(screenShotSlotAuto > 8) screenShotSlotAuto = 1;
					changePreviewUp();
					lastTimeScreenShotSwitch = (FLOAT)tickScreenShotSwitch.QuadPart;
					return 0;
				}

				if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) { 

					if(DisableMenuSounds == 0 && FileMenuSelected != 0) playEffect(0);
					FileMenuSelected--; if(FileMenuSelected < 0) FileMenuSelected = 0;  
					screenShotSlotAuto = 1;
					wasThere = 0;
					changePreview();
					lastTimeScreenShotSwitch = (FLOAT)tickScreenShotSwitch.QuadPart;
					if(FileMenuSelected != 0) updateZipFilename();
					return 0;
				} 
				if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) {  
					if(DisableMenuSounds == 0 && (FileMenuSelected != (fileList.size() - 1))) playEffect(0);	
					FileMenuSelected++; if(FileMenuSelected >= fileList.size()) FileMenuSelected = fileList.size() - 1;
					screenShotSlotAuto = 1;
					wasThere = 0;
					changePreview();
					lastTimeScreenShotSwitch = (FLOAT)tickScreenShotSwitch.QuadPart;
					if(FileMenuSelected != (fileList.size() - 1)) updateZipFilename();
					return 0;
				}

				if (g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] && !g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {   
					if(slow >= 1)  { slow = 0;}
					if(leftAnalog == 255) {
						slow = scrollSpeed;
					}
					else {
						slow += ((float)leftAnalog/255.0f);
					}
					FileMenuSelected-=((int)slow); if(FileMenuSelected < 0) FileMenuSelected = 0;
					menuChanged=true;
					analogScroll();
					return 0;
				}

				if (g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] && !g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {	
					if(slow >= 1) { slow = 0; } 
					if(rightAnalog == 255)
						slow = scrollSpeed;
					else
						slow += ((float)rightAnalog/255.0f);
					FileMenuSelected+=((int)slow);
					if(FileMenuSelected >= fileList.size()) 
						FileMenuSelected = fileList.size() - 1;
					menuChanged=true;
					analogScroll();
					return 0;
				}
				if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_RIGHT && g_Gamepads[0].fX2 == 0 && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) { 
					char c = fileList[FileMenuSelected].name[0];	  
					c = tolower(c);
					for(int i = FileMenuSelected; i < fileList.size(); i++) {
						char n = fileList[i].name[0];
						n = tolower(n);
						if(c == '<' && n != '<') {
							FileMenuSelected = i;
							break;
						}
						if(n > c) {
							FileMenuSelected = i;
							break;
						}
					}
					screenShotSlotAuto = 1;
					wasThere = 0;
					changePreview();
					lastTimeScreenShotSwitch = (FLOAT)tickScreenShotSwitch.QuadPart;
					if(FileMenuSelected != (fileList.size() - 1)) updateZipFilename();
					return 0;
				} 		
				if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_LEFT  && g_Gamepads[0].fX2 == 0 && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && !(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) {  
					char c = fileList[FileMenuSelected].name[0];	  
					c = tolower(c);
					for(int i = FileMenuSelected; i > 0; i--) {
						char n = fileList[i].name[0];
						n = tolower(n);
						if(c == '<' && n != '<') {
							FileMenuSelected = i;
							break;
						}
						if(n <  c) {
							FileMenuSelected = i;
							break;	
						}
					}
					screenShotSlotAuto = 1;
					wasThere = 0;
					changePreview();
					lastTimeScreenShotSwitch = (FLOAT)tickScreenShotSwitch.QuadPart;
					if(FileMenuSelected != 0) updateZipFilename();
					return 0;
				} 
				if (g_Gamepads[0].Event == XBGAMEPAD_Y) {
					FileMenuSelected = 0;
					screenShotSlotAuto = 1;
					wasThere = 0;
					changePreview();
					lastTimeScreenShotSwitch = (FLOAT)tickScreenShotSwitch.QuadPart;
				}
				if ((g_Gamepads[0].Event == XBGAMEPAD_A) && screenResize != 1
					&& screenResizeP != 1 && screenResizeI != 1 && screenResizePB != 1 &&  screenResizeJ != 1 && screenResizeG != 1 
					&& screenResizeB != 1 && screenResizeA != 1 && screenOptionsM != 1 &&  screenResizeS != 1 
					&& screenOptions != 1 && screenControllerOptions != 1 && screenCheatOptions != 1) // A, X or Start
				{
					//dprintf("FileMenuSelected: %d\n", FileMenuSelected);
					if(fileList[FileMenuSelected].topLevel) {
						//dprintf("Top Level\n");
						searchDirectory(fileList[FileMenuSelected].path, true);
						FileMenuSelected = 0;
						return 0;
					}
					if(fileList[FileMenuSelected].isARoot || fileList[FileMenuSelected].isADirectory) {
						//dprintf("Directory or Root\n");
						searchDirectory(fileList[FileMenuSelected].path, false);
						FileMenuSelected = 0;
						return 0; 
					}

					if(fileList[FileMenuSelected].isAGame == false) return 0;
					
					if(musicPlayer == 1 && fileList[FileMenuSelected].soundTrack == -1) return 0; 
					if(musicPlayer == 1) {
						pauseMusic();
					if(musicMode == 0) {
							if(vgplaying == 1) stopMusic();
							switchSongs();
							resumeMusic();
						}
						else {
							InitVGMusic((char*)(fileList[FileMenuSelected].path.c_str()));
						}
						return 0;
					}
					else {
						if(vgplaying == 1) {
							pauseVGMusic();
						}
						else {
							pauseMusic();
						}
					}
					
					clearAnimation();
					firstVidRender = 1;
					inGame = 1;
					SoundEnabled = 1;
					GUIOn2 = 0;
					LoopMode = 8;
					unsigned char *lock=NULL;
					makeVertexListLinear();
					VertexBufferLinear->Lock(0,sizeof(VertexListLinear),&lock,0); if (lock==NULL) return 1;
					memcpy(lock,VertexListLinear,sizeof(VertexListLinear));
					VertexBufferLinear->Unlock();
					Device->SetTexture(0,TexScreen);
					Device->SetStreamSource(0,VertexBufferLinear,sizeof(CustomVertex));
					Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
					Device->SetTextureStageState( 0, D3DTSS_ADDRESSU, D3DTADDRESS_CLAMP );
					Device->SetTextureStageState( 0, D3DTSS_ADDRESSV, D3DTADDRESS_CLAMP );
					pauseMusic();
					for(int i = 0; i < 512; i++) fname[i] = '\0';
					for(int i = 0; i < 512; i++) fnames[i] = '\0';
					for(int i = 0; i < 512; i++) fnamest[i] = '\0';
					initCheatCodes();
					loadCheat();
					fname[0] = fileList[FileMenuSelected].path[0];
					for(int i = 1; i < 512; i++) {
						if(fileList[FileMenuSelected].path[i-1] == '\0') {
							fname[i] = fileList[FileMenuSelected].path[i-1];
							break;
						}
						else {
							fname[i] = fileList[FileMenuSelected].path[i-1];
						}
					}

					//Setup fnames
					std::string t = SRAM_PATH;
					std::string a = fileList[FileMenuSelected].name;
					a[a.size()-3] = 's';
					a[a.size()-2] = 'r';
					a[a.size()-1] = 'm';
					t = t + a;
					for(int i = 0; i < 512; i++) fnames[i] = '\0';
					fnames[0] = t[0];
					for(int i = 1; i < 512+1; i++) {
						if(t[i-1] == '\0') {
							fnames[i] = t[i-1];
							break;
						}
						else {
							fnames[i] = t[i-1];
						}
					}	

					//Setup fnamest
					std::string t2 = SAVE_PATH;
					std::string a2 = fileList[FileMenuSelected].name;
					a2[a2.size()-3] = 'z';
					a2[a2.size()-2] = 's';
					a2[a2.size()-1] = 't';
					t2 = t2 + a2;
					for(int i = 0; i < 512; i++) fnamest[i] = '\0';
					fnamest[0] = t2[0];
					for(int i = 1; i < 512+1; i++) {
						if(t2[i-1] == '\0') {
							fnamest[i] = t2[i-1];
							break;
						}
						else {
							fnamest[i] = t2[i-1];
						}
					}	

					TexScreen->LockRect( 0, &lockScreen, 0, 0L );
					SurfBuf = (BYTE*)lockScreen.pBits;
					pitch = lockScreen.Pitch;

					for(int i = 0; i < 480; i++) {
						for(int j = 0; j < 640 * 2; j++) {
							SurfBuf[(i * pitch) + j] = 0;
						}
					}
					TexScreen->UnlockRect(0);
					if(lpPrimaryBuffer)
					lpPrimaryBuffer->Release();
					InitSound();
					optionSelected = 0;
					En2xSaI = 0;
					antienab = 0;
					hqFilter = 0;
					createSaveStateDirectories();
					SaveSlot(0);
					clearvidsound();
					GUIDoReset();
					asm_call(init);
				}
		}
		return 0;
	}
	int cRumble = 0;
	int aCount = 60;
	int bCount = 60;
	int rumble = 120;
	void WinUpdateDevices()
	{   
		keys = (unsigned char *)&pressed;
		if(LoopMode == 2) {
			while(LoopMode == 2) {
				readInput();
				if(ZsnesMenuUpdate() == 1) return;

				updateEffect();
				DirectSoundDoWork();
				
				
				if(inGame == 0) {
					if( vgplaying == 0) {  
						resumeMusic(); 
						updateSound();
					}
					else {
						if(animateFramevg() == 1) updateVGStream();
						if(animateFramevg2() == 1) songIsOver();
					}
				}
				if(lightGun != 1 && tvMode != 1 && keyBoardDraw != 1)  
					Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );

				if(keyBoardDraw == 1) {
					drawXKeyboard();
				}
				else {
					if(lightGun == 1 || tvMode == 1) {
						if(lightGun == 1) LightGunRender();
					}
					else {
						DirectScreen();
					}
				}
				if (screenResize != 1 && screenOptions != 1 
					&& screenVideoOptions != 1
					&& screenResizeP != 1
					&& screenResizeI != 1
					&& screenResizePB != 1
					&& screenResizeJ != 1
					&& screenResizeG != 1
					&& screenResizeB != 1
					&& screenResizeA != 1
					&& screenResizeE != 1
					&& screenResizeA2 != 1
					&& screenOptionsM != 1
					&& screenMPOptions != 1
					&& screenOptionsHelp != 1
					&& screenResizeS != 1
					&& screenSoundOptions != 1
					&& screenMPOptions != 1
					&& screenLightGunOptions != 1
					&& screenGeneralOptions != 1
					&& screenGeneralOptionsGG != 1
					&& screenGeneralOptionsGGText != 1
					&& screenGUIOptions != 1
					&& saveStateLoad != 1
					&& saveStateSave != 1
					&& screenCheatOptions != 1
					&& fontResizeR != 1
					&& fontResizeEO != 1
					&& fontResizeCO != 1
					&& fontResizeCC != 1
					&& fontResizeClip != 1
					&& fontResizeTO != 1
					&& fontResizeCCO != 1
					&& fontResizeF != 1
					&& fontResizeV != 1
					&& fontResizeRumble != 1
					&& fontResizeGT != 1
					&& fontResizeIT != 1
					&& fontResizeS != 1
					&& fontResizeG != 1
					&& fontResizeCD != 1
					&& fontResizeM != 1
					&& confirmDelete != 1
					&& favoriteAdd != 1
					&& lightGun != 1
					&& screenMPOptions != 1
					&& screenGeneralOptionsMP != 1
					&& tvMode != 1
					&& keyBoardDraw != 1
					&& screenControllerOptions != 1) MenuRender();
				if(lightGun != 1 && tvMode != 1 && keyBoardDraw != 1)  DirectPresent();
			}
			return;
		}
		if(rumbleOneInProgress == true || rumbleTwoInProgress == true) {
			 if(rumbleList[cRumble].rumbleType == 3 || rumbleList[cRumble].rumbleType == 6 || rumbleList[cRumble].rumbleType == 9) { 
				//see if there has been a change, if there has been stop the rumble.
				rumbleList[cRumble].currentValue =  getRumbleValue(rumbleList[cRumble].address, rumbleList[cRumble].bank); 
				if(rumbleList[cRumble].currentValue != rumbleList[cRumble].previousValue) {
				//	//dprintf("Stoping rumble on value change. Type is: %d, New Current Value: %d\n", rumbleList[cRumble].rumbleType, rumbleList[cRumble].currentValue);
					rumbleList[cRumble].previousValue = rumbleList[cRumble].currentValue;
					stopRumble();
				}
			}
			 if(rumbleList[cRumble].rumbleType == 4 || rumbleList[cRumble].rumbleType == 7 || rumbleList[cRumble].rumbleType == 10) { 
				//see if there has been a change, if there has been stop the rumble.
				rumbleList[cRumble].currentValue =  getRumbleValue(rumbleList[cRumble].address, rumbleList[cRumble].bank); 
				if(rumbleList[cRumble].currentValue < rumbleList[cRumble].previousValue) {
					////dprintf("Stoping rumble on value decrease. Type is: %d, New Current Value: %d\n", rumbleList[cRumble].rumbleType, rumbleList[cRumble].currentValue);
					rumbleList[cRumble].previousValue = rumbleList[cRumble].currentValue;
					stopRumble();
				}
			}

			 if(rumbleList[cRumble].rumbleType == 5 || rumbleList[cRumble].rumbleType == 8 || rumbleList[cRumble].rumbleType == 11) { 
				//see if there has been a change, if there has been stop the rumble.
				rumbleList[cRumble].currentValue =  getRumbleValue(rumbleList[cRumble].address, rumbleList[cRumble].bank); 
				if(rumbleList[cRumble].currentValue > rumbleList[cRumble].previousValue) {
					////dprintf("Stoping rumble on valueincrease. Type is: %d, New Current Value: %d\n", rumbleList[cRumble].rumbleType, rumbleList[cRumble].currentValue);
					rumbleList[cRumble].previousValue = rumbleList[cRumble].currentValue;
					stopRumble();
				}
			}
		    if(rumbleList[cRumble].rumbleType == 0 || rumbleList[cRumble].rumbleType == 1 || rumbleList[cRumble].rumbleType == 2) { 
					ProcessRumble();
					if(rumbleTwoInProgress == false && rumbleOneInProgress == false){
						rumbleList[cRumble].currentValue = getRumbleValue(rumbleList[cRumble].address, rumbleList[cRumble].bank); 
						rumbleList[cRumble].previousValue = rumbleList[cRumble].currentValue;
						cRumble = 0;
					}
			  }
		}
		else {
			for(int i = 0; i < 10; i++) { 
				if(rumbleList[i].isActive) {
						rumbleList[i].currentValue = getRumbleValue(rumbleList[i].address, rumbleList[i].bank); 

						unsigned char a  = rumbleList[i].currentValue; 
						unsigned char b  = rumbleList[i].previousValue; 
						int c            = rumbleList[i].rumbleType; 

						////change check for 0, 3, 4, 5
						//Decrease check for 1, 6, 7, 8
						 //Increase check for 2, 9, 10, 11
						if((a != b) & ((c == 0) || (c == 3) || (c == 4) || (c == 5))) { //any change 
							if(rumbleList[i].rumbleCount < rumbleList[i].rumbleTarget) {
								rumbleList[i].rumbleCount ++;
								rumbleList[i].previousValue = rumbleList[i].currentValue;
							}
							else {
								rumbleList[i].previousValue = rumbleList[i].currentValue;
								StartRumble(i);
								cRumble = i;
								break;
							}
						} 
						if((a < b)  & ((c == 1) || (c == 6) || (c == 7) || (c == 8))) { //Decrease
							if(rumbleList[i].rumbleCount < rumbleList[i].rumbleTarget) {
								rumbleList[i].rumbleCount ++;
								rumbleList[i].previousValue = rumbleList[i].currentValue;
							}
							else {
								rumbleList[i].previousValue = rumbleList[i].currentValue;
								StartRumble(i);
								cRumble = i;
								break;
							}
						} 
						if((a > b)  & ((c == 2) || (c == 9) || (c == 10) || (c == 11))) { //increase 
							if(rumbleList[i].rumbleCount < rumbleList[i].rumbleTarget) {
								rumbleList[i].rumbleCount ++;
								rumbleList[i].previousValue = rumbleList[i].currentValue;
							}
							else {
								rumbleList[i].previousValue = rumbleList[i].currentValue;
								////dprintf("Starting rumble for increase. Type is: %d, Current Value: %d\n", c, rumbleList[i].previousValue);
								StartRumble(i);
								cRumble = i;
								break;
							}
						} 
					
						rumbleList[i].previousValue = rumbleList[i].currentValue; 
				} 
			} 
		}
		readInput();
		if(romtype == 2) {
			applyCheatCodesHiROM();
		}
		else {
			applyCheatCodesLoROM();
		}

		if(aCount < 60) { //Delay input so multiple A button presses are not registered
			aCount++;
		}
		else {
			if(controllers[p1].button_B != -1) {
				if(tButtons[0].turboB == 1) {
					if(controllers[p1].button_B == XINPUT_GAMEPAD_BACK ||
						controllers[p1].button_B == XINPUT_GAMEPAD_START ||
						controllers[p1].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p1].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[p1].wButtons & (controllers[p1].button_B & 0xFFFF)) keys[pl1Btk] = 1;     else keys[pl1Btk] = 0; 
					else
						if (g_Gamepads[p1].bAnalogButtons[controllers[p1].button_B]) keys[pl1Btk] = 1;     else keys[pl1Btk] = 0; 
				}
				else {
					if(controllers[p1].button_B == XINPUT_GAMEPAD_BACK ||
						controllers[p1].button_B == XINPUT_GAMEPAD_START ||
						controllers[p1].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p1].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[p1].wButtons & (controllers[p1].button_B & 0xFFFF)) {if(lightGunMode == 0) mousebuttons = 2; keys[pl1Bk] = 1;   }  else {if(lightGunMode == 0) mousebuttons = 0; keys[pl1Bk] = 0; }
					else
						if (g_Gamepads[p1].bAnalogButtons[controllers[p1].button_B]) {if(lightGunMode == 0) mousebuttons = 2;keys[pl1Bk] = 1;    } else {if(lightGunMode == 0) mousebuttons = 0; keys[pl1Bk] = 0; }
				}
			}
		}

		if(controllers[p1].button_Y != -1) {
			if(tButtons[0].turboY == 1) {
				if(controllers[p1].button_Y == XINPUT_GAMEPAD_BACK ||
					controllers[p1].button_Y == XINPUT_GAMEPAD_START ||
					controllers[p1].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p1].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[0].wButtons & (controllers[p1].button_Y & 0xFFFF))  keys[pl1Ytk] = 1;     else keys[pl1Ytk] = 0; 
				else
					if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Y]) keys[pl1Ytk] = 1;     else keys[pl1Ytk] = 0; 
			}
			else {
				if(controllers[p1].button_Y == XINPUT_GAMEPAD_BACK ||
					controllers[p1].button_Y == XINPUT_GAMEPAD_START ||
					controllers[p1].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p1].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[0].wButtons & (controllers[p1].button_Y & 0xFFFF)) {if(lightGunMode == 0)  mousebuttons = 1; keys[pl1Yk] = 1;   }  else { if(lightGunMode == 0) mousebuttons &= 0x02; keys[pl1Yk] = 0; }
				else
					if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Y]) { if(lightGunMode == 0) mousebuttons = 1; keys[pl1Yk] = 1; }    else { if(lightGunMode == 0) mousebuttons &= 0x02; keys[pl1Yk] = 0; }
			}
		}

		if(controllers[p1].button_Start != -1) {
			if(controllers[p1].button_Start == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_Start == XINPUT_GAMEPAD_START ||
				controllers[p1].button_Start == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_Start == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_Start & 0xFFFF))  keys[pl1startk] = 1;     else keys[pl1startk] = 0; 
			else
				if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Start]) keys[pl1startk] = 1;     else keys[pl1startk] = 0; 
		}

		if(controllers[p1].button_Right != -1) {
			if(tButtons[0].turboR == 1) {
				if(controllers[p1].button_Right == XINPUT_GAMEPAD_BACK ||
					controllers[p1].button_Right == XINPUT_GAMEPAD_START ||
					controllers[p1].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p1].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[0].wButtons & (controllers[p1].button_Right & 0xFFFF))  keys[pl1Rtk] = 1;     else keys[pl1Rtk] = 0; 
				else
					if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Right]) {
						////dprintf("Turbo R A\n");
						keys[pl1Rtk] = 1;     
					}
					else {
						////dprintf("Turbo R B\n");
						keys[pl1Rtk] = 0;
					}
			}
			else {
				if(controllers[p1].button_Right == XINPUT_GAMEPAD_BACK ||
					controllers[p1].button_Right == XINPUT_GAMEPAD_START ||
					controllers[p1].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p1].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[0].wButtons & (controllers[p1].button_Right & 0xFFFF))  keys[pl1Rk] = 1;     else keys[pl1Rk] = 0; 
				else
					if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Right]) keys[pl1Rk] = 1;     else keys[pl1Rk] = 0; 
			}
		}

		if(controllers[p1].button_Left != -1) {
			if(tButtons[0].turboL == 1) {
				if(controllers[p1].button_Left == XINPUT_GAMEPAD_BACK ||
					controllers[p1].button_Left == XINPUT_GAMEPAD_START ||
					controllers[p1].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p1].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[0].wButtons & (controllers[p1].button_Left & 0xFFFF))  keys[pl1Ltk] = 1;     else keys[pl1Ltk] = 0; 
				else
					if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Left]) keys[pl1Ltk] = 1;     else keys[pl1Ltk] = 0; 
			}
			else {
				if(controllers[p1].button_Left == XINPUT_GAMEPAD_BACK ||
					controllers[p1].button_Left == XINPUT_GAMEPAD_START ||
					controllers[p1].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p1].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[0].wButtons & (controllers[p1].button_Left & 0xFFFF))  keys[pl1Lk] = 1;     else keys[pl1Lk] = 0; 
				else
					if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Left]) keys[pl1Lk] = 1;     else keys[pl1Lk] = 0; 
			}
		}

		if(controllers[p1].button_X != -1) {
			if(tButtons[0].turboX == 1) {
				if(controllers[p1].button_X == XINPUT_GAMEPAD_BACK ||
					controllers[p1].button_X == XINPUT_GAMEPAD_START ||
					controllers[p1].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p1].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[0].wButtons & (controllers[p1].button_X & 0xFFFF))  keys[pl1Xtk] = 1;     else keys[pl1Xtk] = 0; 
				else
					if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_X]) keys[pl1Xtk] = 1;     else keys[pl1Xtk] = 0; 
			}
			else {
				if(controllers[p1].button_X == XINPUT_GAMEPAD_BACK ||
					controllers[p1].button_X == XINPUT_GAMEPAD_START ||
					controllers[p1].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p1].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[0].wButtons & (controllers[p1].button_X & 0xFFFF))  keys[pl1Xk] = 1;     else keys[pl1Xk] = 0; 
				else
					if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_X]) keys[pl1Xk] = 1;     else keys[pl1Xk] = 0; 
			}
		}

		if(bCount < 60) {
			bCount++;
		}
		else {
			if(tButtons[0].turboA == 1) {
				if(controllers[p1].button_A != -1) {
					if(controllers[p1].button_A == XINPUT_GAMEPAD_BACK ||
						controllers[p1].button_A == XINPUT_GAMEPAD_START ||
						controllers[p1].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p1].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[0].wButtons & (controllers[p1].button_A & 0xFFFF))  keys[pl1Atk] = 1;     else keys[pl1Atk] = 0; 
					else
						if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_A]) keys[pl1Atk] = 1;     else keys[pl1Atk] = 0; 
				}
			}
			else {
				if(controllers[p1].button_A != -1) {
					if(controllers[p1].button_A == XINPUT_GAMEPAD_BACK ||
						controllers[p1].button_A == XINPUT_GAMEPAD_START ||
						controllers[p1].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p1].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[0].wButtons & (controllers[p1].button_A & 0xFFFF))  keys[pl1Ak] = 1;     else keys[pl1Ak] = 0; 
					else
						if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_A]) keys[pl1Ak] = 1;     else keys[pl1Ak] = 0; 
				}
			}
		}

		if(controllers[p1].button_Select != -1) {
			if(controllers[p1].button_Select == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_Select == XINPUT_GAMEPAD_START ||
				controllers[p1].button_Select == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_Select == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_Select & 0xFFFF))  keys[pl1selk] = 1;     else keys[pl1selk] = 0; 
			else
				if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Select]) keys[pl1selk] = 1;     else keys[pl1selk] = 0; 
		}

			if (g_Gamepads[0].fY1 > 0 || g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP)          {  keys[pl1upk] = 1;    } else { keys[pl1upk] = 0; } 
			if (g_Gamepads[0].fY1 < 0 || g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_DOWN)        { keys[pl1downk] = 1;  } else { keys[pl1downk] = 0; }
			if (g_Gamepads[0].fX1 < 0 || g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_LEFT)        {   keys[pl1leftk] = 1;  } else { keys[pl1leftk] = 0;}
			if (g_Gamepads[0].fX1 > 0 || g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT)       {   keys[pl1rightk] = 1; } else { keys[pl1rightk] = 0;}

		if(lightGunMode == 0) {
			
			oldmX = mX;
			oldmY = mY;
			if (g_Gamepads[0].fY1 > 0 || g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP)          {  mY-=mouseDist; keys[pl1upk] = 1;    } else { keys[pl1upk] = 0; } 
			if (g_Gamepads[0].fY1 < 0 || g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_DOWN)        {  mY+=mouseDist; keys[pl1downk] = 1;  } else { keys[pl1downk] = 0; }
			if (g_Gamepads[0].fX1 < 0 || g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_LEFT)        {   mX-=mouseDist; keys[pl1leftk] = 1;  } else { keys[pl1leftk] = 0;}
			if (g_Gamepads[0].fX1 > 0 || g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT)       {   mX+=mouseDist; keys[pl1rightk] = 1; } else { keys[pl1rightk] = 0;}
		}
		
		else {
			oldmX = 0;
			oldmY = 0;
			mX = 0;
			mY = 0;
			
			if(lightgunOnScreen() == 1) {
				mousexloc =(int)getLightGunX();
				mouseyloc = (int)getLightGunY();
			}
		}
		
		//Player 2---------------------------------------------------------------------------------------------
		if(controllers[p2].button_B != -1) {
			if(tButtons[1].turboB == 1) {
				if(controllers[p2].button_B == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_B == XINPUT_GAMEPAD_START ||
					controllers[p2].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_B & 0xFFFF)) keys[pl2Btk] = 1;     else keys[pl2Btk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_B]) keys[pl2Btk] = 1;     else keys[pl2Btk] = 0; 
			}
			else {
				if(controllers[p2].button_B == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_B == XINPUT_GAMEPAD_START ||
					controllers[p2].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_B & 0xFFFF)) keys[pl2Bk] = 1;     else keys[pl2Bk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_B]) keys[pl2Bk] = 1;     else keys[pl2Bk] = 0;
			}
		}

		if(controllers[p2].button_Y != -1) {

			if(tButtons[1].turboY == 1) {
				if(controllers[p2].button_Y == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_Y == XINPUT_GAMEPAD_START ||
					controllers[p2].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_Y & 0xFFFF))  keys[pl2Ytk] = 1;     else keys[pl2Ytk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Y]) keys[pl2Ytk] = 1;     else keys[pl2Ytk] = 0; 
			}
			else {
				if(controllers[p2].button_Y == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_Y == XINPUT_GAMEPAD_START ||
					controllers[p2].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_Y & 0xFFFF))  keys[pl2Yk] = 1;     else keys[pl2Yk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Y]) keys[pl2Yk] = 1;     else keys[pl2Yk] = 0; 

			}
		}


		if(controllers[p2].button_Start != -1) {
			if(controllers[p2].button_Start == XINPUT_GAMEPAD_BACK ||
				controllers[p2].button_Start == XINPUT_GAMEPAD_START ||
				controllers[p2].button_Start == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p2].button_Start == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[1].wButtons & (controllers[p2].button_Start & 0xFFFF))  keys[pl2startk] = 1;     else keys[pl2startk] = 0; 
			else
				if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Start]) keys[pl2startk] = 1;     else keys[pl2startk] = 0; 
		}

		if(controllers[p2].button_Right != -1) {
			if(tButtons[1].turboR == 1) {
				if(controllers[p2].button_Right == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_Right == XINPUT_GAMEPAD_START ||
					controllers[p2].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_Right & 0xFFFF))  keys[pl2Rtk] = 1;     else keys[pl2Rtk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Right]) keys[pl2Rtk] = 1;     else keys[pl2Rtk] = 0; 
			}
			else {
				if(controllers[p2].button_Right == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_Right == XINPUT_GAMEPAD_START ||
					controllers[p2].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_Right & 0xFFFF))  keys[pl2Rk] = 1;     else keys[pl2Rk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Right]) keys[pl2Rk] = 1;     else keys[pl2Rk] = 0; 
			}
		}


		if(controllers[p2].button_Left != -1) {
			if(tButtons[1].turboL == 1) {
				if(controllers[p2].button_Left == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_Left == XINPUT_GAMEPAD_START ||
					controllers[p2].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_Left & 0xFFFF))  keys[pl2Ltk] = 1;     else keys[pl2Ltk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Left]) keys[pl2Ltk] = 1;     else keys[pl2Ltk] = 0; 
			}
			else {
				if(controllers[p2].button_Left == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_Left == XINPUT_GAMEPAD_START ||
					controllers[p2].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_Left & 0xFFFF))  keys[pl2Lk] = 1;     else keys[pl2Lk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Left]) keys[pl2Lk] = 1;     else keys[pl2Lk] = 0; 
			}
		}

		if(controllers[p2].button_X != -1) {
			if(tButtons[1].turboX == 1) {
				if(controllers[p2].button_X == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_X == XINPUT_GAMEPAD_START ||
					controllers[p2].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_X & 0xFFFF))  keys[pl2Xtk] = 1;     else keys[pl2Xtk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_X]) keys[pl2Xtk] = 1;     else keys[pl2Xtk] = 0; 
			}
			else {
				if(controllers[p2].button_X == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_X == XINPUT_GAMEPAD_START ||
					controllers[p2].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_X & 0xFFFF))  keys[pl2Xk] = 1;     else keys[pl2Xk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_X]) keys[pl2Xk] = 1;     else keys[pl2Xk] = 0; 
			}
		}

		if(controllers[p2].button_A != -1) {
			if(tButtons[1].turboA == 1) {
				if(controllers[p2].button_A == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_A == XINPUT_GAMEPAD_START ||
					controllers[p2].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_A & 0xFFFF))  keys[pl2Atk] = 1;     else keys[pl2Atk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_A]) keys[pl2Atk] = 1;     else keys[pl2Atk] = 0; 
			}
			else {
				if(controllers[p2].button_A == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_A == XINPUT_GAMEPAD_START ||
					controllers[p2].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_A & 0xFFFF))  keys[pl2Ak] = 1;     else keys[pl2Ak] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_A]) keys[pl2Ak] = 1;     else keys[pl2Ak] = 0;
			}
		}

		if(controllers[p2].button_Select != -1) {
			if(controllers[p2].button_Select == XINPUT_GAMEPAD_BACK ||
				controllers[p2].button_Select == XINPUT_GAMEPAD_START ||
				controllers[p2].button_Select == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p2].button_Select == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[1].wButtons & (controllers[p2].button_Select & 0xFFFF))  keys[pl2selk] = 1;     else keys[pl2selk] = 0; 
			else
				if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Select]) keys[pl2selk] = 1;     else keys[pl2selk] = 0; 
		}

		if (g_Gamepads[1].fY1 > 0 || g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_UP)            keys[pl2upk] = 1;    else keys[pl2upk] = 0; 
		if (g_Gamepads[1].fY1 < 0 || g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_DOWN)          keys[pl2downk] = 1;  else keys[pl2downk] = 0;
		if (g_Gamepads[1].fX1 < 0 || g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_LEFT)          keys[pl2leftk] = 1;  else keys[pl2leftk] = 0;
		if (g_Gamepads[1].fX1 > 0 || g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT)         keys[pl2rightk] = 1; else keys[pl2rightk] = 0;

		if(true) {
			//Player 3---------------------------------------------------------------------------------------------
			if(controllers[p3].button_B != -1) {
				if(tButtons[2].turboB == 1) {
					if(controllers[p3].button_B == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_B == XINPUT_GAMEPAD_START ||
						controllers[p3].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_B & 0xFFFF)) keys[pl3Btk] = 1;     else keys[pl3Btk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_B]) keys[pl3Btk] = 1;     else keys[pl3Btk] = 0; 
				}
				else {
					if(controllers[p3].button_B == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_B == XINPUT_GAMEPAD_START ||
						controllers[p3].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_B & 0xFFFF)) keys[pl3Bk] = 1;     else keys[pl3Bk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_B]) keys[pl3Bk] = 1;     else keys[pl3Bk] = 0;
				}
			}

			if(controllers[p3].button_Y != -1) {

				if(tButtons[2].turboY == 1) {
					if(controllers[p3].button_Y == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_Y == XINPUT_GAMEPAD_START ||
						controllers[p3].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_Y & 0xFFFF))  keys[pl3Ytk] = 1;     else keys[pl3Ytk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Y]) keys[pl3Ytk] = 1;     else keys[pl3Ytk] = 0; 
				}
				else {
					if(controllers[p3].button_Y == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_Y == XINPUT_GAMEPAD_START ||
						controllers[p3].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_Y & 0xFFFF))  keys[pl3Yk] = 1;     else keys[pl3Yk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Y]) keys[pl3Yk] = 1;     else keys[pl3Yk] = 0; 

				}
			}


			if(controllers[p3].button_Start != -1) {
				if(controllers[p3].button_Start == XINPUT_GAMEPAD_BACK ||
					controllers[p3].button_Start == XINPUT_GAMEPAD_START ||
					controllers[p3].button_Start == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p3].button_Start == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[2].wButtons & (controllers[p3].button_Start & 0xFFFF))  keys[pl3startk] = 1;     else keys[pl3startk] = 0; 
				else
					if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Start]) keys[pl3startk] = 1;     else keys[pl3startk] = 0; 
			}

			if(controllers[p3].button_Right != -1) {
				if(tButtons[2].turboR == 1) {
					if(controllers[p3].button_Right == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_Right == XINPUT_GAMEPAD_START ||
						controllers[p3].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_Right & 0xFFFF))  keys[pl3Rtk] = 1;     else keys[pl3Rtk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Right]) keys[pl3Rtk] = 1;     else keys[pl3Rtk] = 0; 
				}
				else {
					if(controllers[p3].button_Right == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_Right == XINPUT_GAMEPAD_START ||
						controllers[p3].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_Right & 0xFFFF))  keys[pl3Rk] = 1;     else keys[pl3Rk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Right]) keys[pl3Rk] = 1;     else keys[pl3Rk] = 0; 
				}
			}
			if(controllers[p3].button_Left != -1) {
				if(tButtons[2].turboL == 1) {
					if(controllers[p3].button_Left == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_Left == XINPUT_GAMEPAD_START ||
						controllers[p3].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_Left & 0xFFFF))  keys[pl3Ltk] = 1;     else keys[pl3Ltk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Left]) keys[pl3Ltk] = 1;     else keys[pl3Ltk] = 0; 
				}
				else {
					if(controllers[p3].button_Left == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_Left == XINPUT_GAMEPAD_START ||
						controllers[p3].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_Left & 0xFFFF))  keys[pl3Lk] = 1;     else keys[pl3Lk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Left]) keys[pl3Lk] = 1;     else keys[pl3Lk] = 0; 
				}
			}

			if(controllers[p3].button_X != -1) {
				if(tButtons[2].turboX == 1) {
					if(controllers[p3].button_X == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_X == XINPUT_GAMEPAD_START ||
						controllers[p3].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_X & 0xFFFF))  keys[pl3Xtk] = 1;     else keys[pl3Xtk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_X]) keys[pl3Xtk] = 1;     else keys[pl3Xtk] = 0; 
				}
				else {
					if(controllers[p3].button_X == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_X == XINPUT_GAMEPAD_START ||
						controllers[p3].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_X & 0xFFFF))  keys[pl3Xk] = 1;     else keys[pl3Xk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_X]) keys[pl3Xk] = 1;     else keys[pl3Xk] = 0; 
				}
			}

			if(controllers[p3].button_A != -1) {
				if(tButtons[2].turboA == 1) {
					if(controllers[p3].button_A == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_A == XINPUT_GAMEPAD_START ||
						controllers[p3].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_A & 0xFFFF))  keys[pl3Atk] = 1;     else keys[pl3Atk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_A]) keys[pl3Atk] = 1;     else keys[pl3Atk] = 0; 
				}
				else {
					if(controllers[p3].button_A == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_A == XINPUT_GAMEPAD_START ||
						controllers[p3].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_A & 0xFFFF))  keys[pl3Ak] = 1;     else keys[pl3Ak] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_A]) keys[pl3Ak] = 1;     else keys[pl3Ak] = 0;
				}
			}

			if(controllers[p3].button_Select != -1) {
				if(controllers[p3].button_Select == XINPUT_GAMEPAD_BACK ||
					controllers[p3].button_Select == XINPUT_GAMEPAD_START ||
					controllers[p3].button_Select == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p3].button_Select == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[2].wButtons & (controllers[p3].button_Select & 0xFFFF))  keys[pl3selk] = 1;     else keys[pl3selk] = 0; 
				else
					if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Select]) keys[pl3selk] = 1;     else keys[pl3selk] = 0; 
			}

			if (g_Gamepads[2].fY1 > 0 || g_Gamepads[2].wButtons & XINPUT_GAMEPAD_DPAD_UP)            keys[pl3upk] = 1;    else keys[pl3upk] = 0; 
			if (g_Gamepads[2].fY1 < 0 || g_Gamepads[2].wButtons & XINPUT_GAMEPAD_DPAD_DOWN)          keys[pl3downk] = 1;  else keys[pl3downk] = 0;
			if (g_Gamepads[2].fX1 < 0 || g_Gamepads[2].wButtons & XINPUT_GAMEPAD_DPAD_LEFT)          keys[pl3leftk] = 1;  else keys[pl3leftk] = 0;
			if (g_Gamepads[2].fX1 > 0 || g_Gamepads[2].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT)         keys[pl3rightk] = 1; else keys[pl3rightk] = 0;

			//Player 4---------------------------------------------------------------------------------------------
			if(controllers[p4].button_B != -1) {
				if(tButtons[3].turboB == 1) {
					if(controllers[p4].button_B == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_B == XINPUT_GAMEPAD_START ||
						controllers[p4].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_B & 0xFFFF)) keys[pl4Btk] = 1;     else keys[pl4Btk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_B]) keys[pl4Btk] = 1;     else keys[pl4Btk] = 0; 
				}
				else {
					if(controllers[p4].button_B == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_B == XINPUT_GAMEPAD_START ||
						controllers[p4].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_B & 0xFFFF)) keys[pl4Bk] = 1;     else keys[pl4Bk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_B]) keys[pl4Bk] = 1;     else keys[pl4Bk] = 0;
				}
			}

			if(controllers[p4].button_Y != -1) {

				if(tButtons[3].turboY == 1) {
					if(controllers[p4].button_Y == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_Y == XINPUT_GAMEPAD_START ||
						controllers[p4].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_Y & 0xFFFF))  keys[pl4Ytk] = 1;     else keys[pl4Ytk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Y]) keys[pl4Ytk] = 1;     else keys[pl4Ytk] = 0; 
				}
				else {
					if(controllers[p4].button_Y == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_Y == XINPUT_GAMEPAD_START ||
						controllers[p4].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_Y & 0xFFFF))  keys[pl4Yk] = 1;     else keys[pl4Yk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Y]) keys[pl4Yk] = 1;     else keys[pl4Yk] = 0; 

				}
			}


			if(controllers[p4].button_Start != -1) {
				if(controllers[p4].button_Start == XINPUT_GAMEPAD_BACK ||
					controllers[p4].button_Start == XINPUT_GAMEPAD_START ||
					controllers[p4].button_Start == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p4].button_Start == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[3].wButtons & (controllers[p4].button_Start & 0xFFFF))  keys[pl4startk] = 1;     else keys[pl4startk] = 0; 
				else
					if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Start]) keys[pl4startk] = 1;     else keys[pl4startk] = 0; 
			}

			if(controllers[p4].button_Right != -1) {
				if(tButtons[3].turboR == 1) {
					if(controllers[p4].button_Right == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_Right == XINPUT_GAMEPAD_START ||
						controllers[p4].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_Right & 0xFFFF))  keys[pl4Rtk] = 1;     else keys[pl4Rtk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Right]) keys[pl4Rtk] = 1;     else keys[pl4Rtk] = 0; 
				}
				else {
					if(controllers[p4].button_Right == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_Right == XINPUT_GAMEPAD_START ||
						controllers[p4].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_Right & 0xFFFF))  keys[pl4Rk] = 1;     else keys[pl4Rk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Right]) keys[pl4Rk] = 1;     else keys[pl4Rk] = 0; 
				}
			}


			if(controllers[p4].button_Left != -1) {
				if(tButtons[3].turboL == 1) {
					if(controllers[p4].button_Left == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_Left == XINPUT_GAMEPAD_START ||
						controllers[p4].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_Left & 0xFFFF))  keys[pl4Ltk] = 1;     else keys[pl4Ltk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Left]) keys[pl4Ltk] = 1;     else keys[pl4Ltk] = 0; 
				}
				else {
					if(controllers[p4].button_Left == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_Left == XINPUT_GAMEPAD_START ||
						controllers[p4].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_Left & 0xFFFF))  keys[pl4Lk] = 1;     else keys[pl4Lk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Left]) keys[pl4Lk] = 1;     else keys[pl4Lk] = 0; 
				}
			}

			if(controllers[p4].button_X != -1) {
				if(tButtons[3].turboX == 1) {
					if(controllers[p4].button_X == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_X == XINPUT_GAMEPAD_START ||
						controllers[p4].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_X & 0xFFFF))  keys[pl4Xtk] = 1;     else keys[pl4Xtk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_X]) keys[pl4Xtk] = 1;     else keys[pl4Xtk] = 0; 
				}
				else {
					if(controllers[p4].button_X == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_X == XINPUT_GAMEPAD_START ||
						controllers[p4].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_X & 0xFFFF))  keys[pl4Xk] = 1;     else keys[pl4Xk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_X]) keys[pl4Xk] = 1;     else keys[pl4Xk] = 0; 
				}
			}

			if(controllers[p4].button_A != -1) {
				if(tButtons[3].turboA == 1) {
					if(controllers[p4].button_A == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_A == XINPUT_GAMEPAD_START ||
						controllers[p4].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_A & 0xFFFF))  keys[pl4Atk] = 1;     else keys[pl4Atk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_A]) keys[pl4Atk] = 1;     else keys[pl4Atk] = 0; 
				}
				else {
					if(controllers[p4].button_A == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_A == XINPUT_GAMEPAD_START ||
						controllers[p4].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_A & 0xFFFF))  keys[pl4Ak] = 1;     else keys[pl4Ak] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_A]) keys[pl4Ak] = 1;     else keys[pl4Ak] = 0;
				}
			}

			if(controllers[p4].button_Select != -1) {
				if(controllers[p4].button_Select == XINPUT_GAMEPAD_BACK ||
					controllers[p4].button_Select == XINPUT_GAMEPAD_START ||
					controllers[p4].button_Select == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p4].button_Select == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[3].wButtons & (controllers[p4].button_Select & 0xFFFF))  keys[pl4selk] = 1;     else keys[pl4selk] = 0; 
				else
					if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Select]) keys[pl4selk] = 1;     else keys[pl4selk] = 0; 
			}

			if (g_Gamepads[3].fY1 > 0 || g_Gamepads[3].wButtons & XINPUT_GAMEPAD_DPAD_UP)            keys[pl4upk] = 1;    else keys[pl4upk] = 0; 
			if (g_Gamepads[3].fY1 < 0 || g_Gamepads[3].wButtons & XINPUT_GAMEPAD_DPAD_DOWN)          keys[pl4downk] = 1;  else keys[pl4downk] = 0;
			if (g_Gamepads[3].fX1 < 0 || g_Gamepads[3].wButtons & XINPUT_GAMEPAD_DPAD_LEFT)          keys[pl4leftk] = 1;  else keys[pl4leftk] = 0;
			if (g_Gamepads[3].fX1 > 0 || g_Gamepads[3].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT)         keys[pl4rightk] = 1; else keys[pl4rightk] = 0;
		}

		//Utility Functions------------------------------------------------------------------------------------
		if(ShowFPS == 1) {
			if(controllers[0].button_ShowFPS != -1) {
				//////dprintf("FPS != -1\n");	
				if( controllers[0].button_ShowFPS == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[0].button_ShowFPS == XINPUT_GAMEPAD_LEFT_THUMB) {
						if (g_Gamepads[0].wButtons & (controllers[0].button_ShowFPS & 0xFFFF)) {
							FPSAtStart ^= 1; FPSOn ^= 1; 
						}

					}
				else { 
					if (g_Gamepads[0].Event == controllers[0].button_ShowFPS) {
						FPSAtStart ^= 1; FPSOn ^= 1; 
					}
				}
			}
		}

		if(EnableAudioAdjust == 1) { 
			if (g_Gamepads[0].fY2 > 0) keys[KeyVolUp] = 1; else keys[KeyVolUp] = 0; 
			if (g_Gamepads[0].fY2 < 0) keys[KeyVolDown] = 1; else keys[KeyVolDown] = 0; 
		}
		else {
			keys[KeyVolUp] = 0;
			keys[KeyVolDown] = 0;
		}

		if(controllers[0].button_FastForward != -1) {
			if(controllers[0].button_FastForward == XINPUT_GAMEPAD_BACK ||
				controllers[0].button_FastForward == XINPUT_GAMEPAD_START ||
				controllers[0].button_FastForward == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[0].button_FastForward == XINPUT_GAMEPAD_LEFT_THUMB) {
					if (g_Gamepads[0].wButtons & (controllers[0].button_FastForward & 0xFFFF)) 
						keys[KeyFastFrwrd] = 1;  
					else 
						keys[KeyFastFrwrd] = 0; 
				}
			else { 
				if (g_Gamepads[0].bAnalogButtons[controllers[0].button_FastForward])
					keys[KeyFastFrwrd] = 1;  
				else  
					keys[KeyFastFrwrd] = 0; 
			}
		}

		if(controllers[0].button_SaveState != -1) {
			if(controllers[0].button_SaveState == XINPUT_GAMEPAD_BACK ||
				controllers[0].button_SaveState == XINPUT_GAMEPAD_START ||
				controllers[0].button_SaveState == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[0].button_SaveState == XINPUT_GAMEPAD_LEFT_THUMB) {
					if(!DisableSaveStates) {
						if (g_Gamepads[0].wButtons & (controllers[0].button_SaveState & 0xFFFF)) { 
							SaveSlot(0); 
							keys[KeySaveState] = 1;  
						}
					}
				}	 
			else {
				if(!DisableSaveStates) {
					if (g_Gamepads[0].bAnalogButtons[controllers[0].button_SaveState]) {
						SaveSlot(0); 
						keys[KeySaveState] = 1;  
					}
				}
			}
		}

		if(controllers[0].button_LoadState != -1) {
			if(controllers[0].button_LoadState == XINPUT_GAMEPAD_BACK ||
				controllers[0].button_LoadState == XINPUT_GAMEPAD_START ||
				controllers[0].button_LoadState == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[0].button_LoadState == XINPUT_GAMEPAD_LEFT_THUMB) {
					if(!DisableSaveStates) {
						if (g_Gamepads[0].wButtons & (controllers[0].button_LoadState & 0xFFFF))  {
							SaveSlot(0); 
							stopRumble();
							keys[KeyLoadState] = 1;
						}
					}
				}  else { 
					if(!DisableSaveStates) {
						if (g_Gamepads[0].bAnalogButtons[controllers[0].button_LoadState])  {
							SaveSlot(0);
							stopRumble();
							keys[KeyLoadState] = 1;
						}
					}
				}
		}

		if(controllers[0].button_Rewind != -1) {
			if(controllers[0].button_Rewind == XINPUT_GAMEPAD_BACK ||
				controllers[0].button_Rewind == XINPUT_GAMEPAD_START ||
				controllers[0].button_Rewind == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[0].button_Rewind == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[0].button_Rewind & 0xFFFF))  { stopRumble(); keys[KeyRewind] = 1;  }  else { keys[KeyRewind] = 0; }  
			else
				if (g_Gamepads[0].bAnalogButtons[controllers[0].button_Rewind]) { stopRumble();  keys[KeyRewind] = 1;} else { keys[KeyRewind] = 0; } 
		}

		int eXit = 0;

		if(controllers[0].button_ExitGame  != -1) {
			if(controllers[0].button_ExitGame == XINPUT_GAMEPAD_BACK ||
				controllers[0].button_ExitGame == XINPUT_GAMEPAD_START ||
				controllers[0].button_ExitGame == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[0].button_ExitGame == XINPUT_GAMEPAD_LEFT_THUMB) {
					if (g_Gamepads[0].wButtons & (controllers[0].button_ExitGame & 0xFFFF))  
						eXit = 1; 
				}
			else {
				if (g_Gamepads[0].bAnalogButtons[controllers[0].button_ExitGame]) eXit = 1; 
			}
		}
		if(disableCombo == 0) { 
			if ((g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
				(g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_BACK)) {  
					if(!DisableSaveStates)keys[KeySaveState] = 1; 
				}

				if ((g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && 
					(g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_BACK)) {  
						if(!DisableSaveStates)keys[KeyLoadState] = 1; 
						stopRumble();
					}
					if(  
						(g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_BACK) &&
						(g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )
						) { eXit = 1; }
		}

		//The sequence here is important. For some reason the app may crash if this sequence is changed.
		if (eXit){
			stopRumble();
			zLeftScale = zLeft + -13.333f;
			zRightScale = zRight + 13.333f;
			zTopScale = zTop + 10.0f;
			zBottomScale = zBottom + -10.0f;
			leftMove =   ((zLeftB -  (zLeftScale)) / zoomSpeed);   ///   0.6;
			rightMove  = (((zRightScale) - zRightB) / zoomSpeed) ;     //0.6;
			topMove  = (((zTopScale) - zTopB) / zoomSpeed) ; 
			bottomMove = ((zBottomB -  (zBottomScale)) / zoomSpeed);
			zoomOver = 0;
			lpPrimaryBuffer->Stop(); 
			optionSelected = 0;
			asm_call(SaveSramData);
			Clear2xSaIBuffer();
			LoopMode = 2; 
			SoundEnabled = 0;
			screenOptions = 1;
			inGame = 1;
			firstExit = 1;
		}
	}

	void screenShotTexture() {
		DWORD *SURFDW;
		ScreenPtr=vidbuffer;   
		ScreenPtr+=16*2+32*2+256*2;
		TexScreenShot->LockRect( 0, &lockScreen, 0, 0L );
		SurfBuf = (BYTE*)lockScreen.pBits;
		SurfBufD=(DWORD) &SurfBuf[0];
		SURFDW=(DWORD *) &SurfBuf[0];
		pitch = lockScreen.Pitch;
		Mode7HiRes16b = 0;
		En2xSaI = 0;
		scanlines = 0;
		hqFilter = 0;
		antienab = 0;
		SurfaceX = 320;
		SurfaceY = 240;
		DrawWin320x240x16();
		TexScreenShot->UnlockRect(0);
	}

	void UpdateVFrame(void)
	{
		WinUpdateDevices();
		CheckTimers();
		//if(LoopMode == 2) return;
		if (SoundEnabled == 0) { return; }
		lpPrimaryBuffer->GetCurrentPosition(&CurrentPos,&WritePos);
		if (LastUsedPos <= CurrentPos)
			DataNeeded=CurrentPos-LastUsedPos;
		else
			DataNeeded=SoundBufferSize - LastUsedPos + CurrentPos;

		DataNeeded /=(512); //2 * 256 (2 * 128 (2 * 64 (2 * 32 (2 * 16 (2 * 8 ( 2 * 4 ( 2 * 2 (2 * 1
		DataNeeded *=(512);
		//0000 0001 0000 0000
		while (DataNeeded>0)
		{
			asm_call(SoundProcess);
			DSPBuffer1=(int *)&DSPBuffer;
			buffer_ptr = (int)&Buffer[0];
			ASM_BEGIN
				ASM_COMMAND3(mov esi,DSPBuffer1)
				ASM_COMMAND3(mov edi,buffer_ptr)
				ASM_COMMAND3(mov ecx,256)
				ASM_COMMAND2(shr ecx,2)
				ASM_COMMAND(_top_mmx:)
				ASM_COMMAND2(movq mm0,[esi])
				ASM_COMMAND2(packssdw mm0,[esi+8])
				ASM_COMMAND2(movq [edi],mm0)
				ASM_COMMAND2(add esi,16)
				ASM_COMMAND2(add edi,8)
				ASM_COMMAND(dec ecx)
				ASM_COMMAND(jne _top_mmx)
				ASM_COMMAND(emms)
				ASM_END
				lpPrimaryBuffer->Lock(LastUsedPos,512, &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0);
			memcpy(lpvPtr1, &Buffer[0], dwBytes1); if (NULL != lpvPtr2) memcpy(lpvPtr2, &Buffer[0]+dwBytes1, dwBytes2);
			LastUsedPos+=512;
			if (LastUsedPos==SoundBufferSize) LastUsedPos=0;
			DataNeeded-=(512);
		}
	}

	extern "C" {
		//extern unsigned char scanlines;
		extern unsigned char cfgscanline;
	}

#include "render.h"
	void drawscreenwin(void) //This is where the contents of the ZSNES video buffer get copied to a Direct3D texture. This texture is then drawn on the screen.
	{
		//Process sound updates.
		UpdateVFrame();

		if (curblank!=0) return;

		//firstVidRender gets set to 1 on a filter 
		//change to have ZSNES do 1 frame of black to
		//clear out any previous graphics in vidbuffer
		//EmuScreen is a temporary buffer used for filters not supported by ZSNES.
		
		//Hack
		if(firstVidRender < 5) {//Render 5 frames of black
			asm_call(Clear2xSaIBuffer);
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 0;
			hqFilter = 0;
			antienab = 0;
			firstVidRender++;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= (unsigned char*) &(SurfBuf[(240-resolutn)*pitch+128]);
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);  
			return;
		}
		(*renderMethod[SoftwareFilter])(); //Call the appropriate render method based on what software filter is selected.
	
		//if(showAvailMemory)
		//	showMemory();
	
	}

}//end of extern "C"
